Game_BattlerBase.prototype.eraseState = function(stateId) {
    var index = this._states.indexOf(stateId);
    if (index >= 0) {
        this._states.splice(index, 1);
    }
};

Game_BattlerBase.prototype.isStateAffected = function(stateId) {
    return this._states.contains(stateId);
};

Game_BattlerBase.prototype.isDeathStateAffected = function() {
    return false
};

Game_BattlerBase.prototype.resetStateCounts = function(stateId) {
};

Game_BattlerBase.prototype.isStateExpired = function(stateId) {
    return false
};

Game_BattlerBase.prototype.updateStateTurns = function() {
};

Game_BattlerBase.prototype.isStateResist = function(stateId) {
    return false
};

Game_BattlerBase.prototype.refresh = function() {
    this._hp = this._hp.clamp(0, this.mhp);
    this._mp = this._mp.clamp(0, this.mmp);
    this._tp = this._tp.clamp(0, this.maxTp());
};

Game_BattlerBase.prototype.recoverAll = function() {
    this._hp = this.mhp;
    this._mp = this.mmp;
};

Game_BattlerBase.prototype.restriction = function() {
    return Math.max.apply(null, this.states().map(function(state) {
        return state.restriction;
    }).concat(0));
};

Game_BattlerBase.prototype.addNewState = function(stateId) {
    this._states.push(stateId);
};

Game_BattlerBase.prototype.mostImportantStateText = function() {
    return '';
};

Game_BattlerBase.prototype.stateMotionIndex = function() {
    var states = this.states();
    if (states.length > 0) {
        return states[0].motion;
    } else {
        return 0;
    }
};

Game_BattlerBase.prototype.stateOverlayIndex = function() {
    var states = this.states();
    if (states.length > 0) {
        return states[0].overlay;
    } else {
        return 0;
    }
};

Game_Battler.prototype.refresh = function() {
    Game_BattlerBase.prototype.refresh.call(this);
};

Game_Battler.prototype.addState = function(stateId) {
	if (!this.isStateAffected(stateId)) {
		this.addNewState(stateId);
		this.refresh();
	}
};

Game_Battler.prototype.isStateRestrict = function(stateId) {
    return false
};

Game_Battler.prototype.onRestrict = function() {
};

Game_Battler.prototype.removeState = function(stateId) {
    if (this.isStateAffected(stateId)) {
        this.eraseState(stateId);
        this.refresh();
    }
};

Game_Battler.prototype.removeBattleStates = function() {
};

Game_Battler.prototype.removeStatesAuto = function(timing) {
};

Game_Battler.prototype.removeStatesByDamage = function() {
};

Game_Actor.prototype.clearStates = function() {
    Game_Battler.prototype.clearStates.call(this);
};

Game_Actor.prototype.eraseState = function(stateId) {
    Game_Battler.prototype.eraseState.call(this, stateId);
};

Game_Actor.prototype.resetStateCounts = function(stateId) {
    Game_Battler.prototype.resetStateCounts.call(this, stateId);
};

Game_Actor.prototype.onPlayerWalk = function() {
    this.clearResult();
    this.checkFloorEffect();
    if ($gamePlayer.isNormal()) {
        this.turnEndOnMap();
    }
};

Game_Party.prototype.removeBattleStates = function() {
};



// Change State
Game_Interpreter.prototype.command313 = function() {
    this.iterateActorEx(this._params[0], this._params[1], function(actor) {
	//this._params; [0, 1, 1, 69] //removes
	//[0, 1, 0, 69] //adds
	//[0, 1, [0 to add, 1 to remove], state]

        if (this._params[2] === 0) {
						if (!actor.isStateAffected(this._params[3])) {
							$gameVariables.value(139).push([this._params[3],1])
						}
            actor.addState(this._params[3]);

			if (this._params[3] == 69) { //remove alynn
				if (v(186) == 4) {
					vset(186, 5) //set alynn var to 5 if equal to 4
				}
			}

        }
		else {
						if (actor.isStateAffected(this._params[3])) {
							$gameVariables.value(139).push([this._params[3],-1])
						}
            actor.removeState(this._params[3]);
			
			if (this._params[3] == 69) { //remove alynn
				if (v(186) == 5) {
					vset(186, 4) //set alynn var to 4 if equal to 5
				}
			}
        }
//        actor.clearResult();

		updatestateports() //portrait chgs
		
		$gameVariables.setValue(148, mys());
		$gameVariables.setValue(152, sen());
			
    }.bind(this));
    return true;
};

